/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.js.debug.core.JSLaunchConfigurationDelegate;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.Messages;
import com.aptana.js.debug.ui.internal.WorkbenchCloseListener;
import com.aptana.ui.PopupSchedulingRule;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.util.WorkbenchBrowserUtil;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public final class LaunchConfigurationsHelper {
    private LaunchConfigurationsHelper() {
    }

    public static void doCheckDefaultLaunchConfigurations() {
        JSLaunchConfigurationDelegate.setCheckFirefoxLocationListener((JSLaunchConfigurationDelegate.Listener)new JSLaunchConfigurationDelegate.Listener(){

            public String checkFirefoxLocation() {
                return LaunchConfigurationsHelper.showBrowserNotFoundDialog(true);
            }
        });
        UIJob job = new UIJob("Checking default launch configuration"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                new LaunchConfigurationsHelper(null).checkDefaultLaunchConfiguration();
                WorkbenchCloseListener.init();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)PopupSchedulingRule.INSTANCE);
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    private void checkDefaultLaunchConfiguration() {
        Stack<ILaunchConfiguration> defaultConfigurations = new Stack<ILaunchConfiguration>();
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        ILaunchConfiguration[] history = manager.getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug").getHistory();
        ILaunchConfiguration configuration = this.getOrCreateDefaultLaunchConfiguration("Firefox");
        if (configuration != null) {
            defaultConfigurations.push(configuration);
        }
        if ("win32".equals(Platform.getOS()) && (configuration = this.getOrCreateDefaultLaunchConfiguration("Internet Explorer")) != null) {
            defaultConfigurations.push(configuration);
        }
        ILaunchConfiguration[] iLaunchConfigurationArray = history;
        int n = history.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration i = iLaunchConfigurationArray[n2];
            Iterator j = defaultConfigurations.iterator();
            while (j.hasNext()) {
                if (!i.equals(j.next())) continue;
                j.remove();
                break;
            }
            ++n2;
        }
        while (!defaultConfigurations.empty()) {
            configuration = (ILaunchConfiguration)defaultConfigurations.pop();
            this.setRecentLaunchHistory("org.eclipse.debug.ui.launchGroup.run", configuration);
            this.setRecentLaunchHistory("org.eclipse.debug.ui.launchGroup.debug", configuration);
        }
    }

    private void setRecentLaunchHistory(String groupId, final ILaunchConfiguration configuration) {
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        LaunchHistory history = manager.getLaunchHistory(groupId);
        history.launchAdded(new ILaunch(){

            public ILaunchConfiguration getLaunchConfiguration() {
                return configuration;
            }

            public Object[] getChildren() {
                return null;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public IProcess[] getProcesses() {
                return null;
            }

            public IDebugTarget[] getDebugTargets() {
                return null;
            }

            public void addDebugTarget(IDebugTarget target) {
            }

            public void removeDebugTarget(IDebugTarget target) {
            }

            public void addProcess(IProcess process) {
            }

            public void removeProcess(IProcess process) {
            }

            public ISourceLocator getSourceLocator() {
                return null;
            }

            public void setSourceLocator(ISourceLocator sourceLocator) {
            }

            public String getLaunchMode() {
                return null;
            }

            public void setAttribute(String key, String value) {
            }

            public String getAttribute(String key) {
                return null;
            }

            public boolean hasChildren() {
                return false;
            }

            public boolean canTerminate() {
                return false;
            }

            public boolean isTerminated() {
                return false;
            }

            public void terminate() throws DebugException {
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        });
    }

    private ILaunchConfiguration getOrCreateDefaultLaunchConfiguration(String nature) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (nature.equals(config.getAttribute("browserNature", ""))) {
                    String browserExecutable;
                    if ("Firefox".equals(nature) && StringUtil.isEmpty((String)(browserExecutable = config.getAttribute("browserExecutable", "")))) {
                        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                        JSLaunchConfigurationHelper.setBrowserDefaults((ILaunchConfigurationWorkingCopy)wc, (String)nature);
                        wc.doSave();
                    }
                    return config;
                }
                ++n2;
            }
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(String.valueOf(nature) + " - Internal Server"));
            JSLaunchConfigurationHelper.setDefaults((ILaunchConfigurationWorkingCopy)wc, (String)nature);
            return wc.doSave();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private ILaunchConfigurationType getLaunchConfigType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType("com.aptana.js.debug.core.webbrowserLaunchConfigurationType");
    }

    public static String showBrowserNotFoundDialog(final boolean download) {
        final String[] path = new String[1];
        UIUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialogWithToggle md = new MessageDialogWithToggle(UIUtils.getActiveShell(), Messages.Startup_Notification, null, Messages.Startup_StudioRequiresFirefox, 2, new String[]{StringUtil.ellipsify((String)CoreStrings.BROWSE), download ? Messages.Startup_Download : Messages.Startup_CheckAgain, IDialogConstants.CANCEL_LABEL}, 0, Messages.Startup_DontAskAgain, false);
                md.setPrefKey("com.aptana.js.debug.ui.skip_firefox_check");
                md.setPrefStore(JSDebugUIPlugin.getDefault().getPreferenceStore());
                int returnCode = md.open();
                switch (returnCode) {
                    case 256: {
                        FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                        if ("win32".equals(Platform.getOS())) {
                            fileDialog.setFilterExtensions(new String[]{"*.exe"});
                            fileDialog.setFilterNames(new String[]{Messages.Startup_ExecutableFiles});
                        }
                        path[0] = fileDialog.open();
                        break;
                    }
                    case 257: {
                        if (download) {
                            WorkbenchBrowserUtil.launchExternalBrowser((String)"http://www.getfirefox.com");
                        }
                        path[0] = "";
                    }
                }
            }
        });
        return path[0];
    }

    /* synthetic */ LaunchConfigurationsHelper(LaunchConfigurationsHelper launchConfigurationsHelper) {
        this();
    }
}

